VERSION 5.00
Begin VB.Form FrmMain 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Rss Reader"
   ClientHeight    =   4620
   ClientLeft      =   -15
   ClientTop       =   375
   ClientWidth     =   9240
   Icon            =   "FrmMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4620
   ScaleWidth      =   9240
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton CmdExit 
      Caption         =   "Salir"
      Height          =   375
      Left            =   7920
      TabIndex        =   5
      ToolTipText     =   "Detiene la aplicacin"
      Top             =   4080
      Width           =   1215
   End
   Begin VB.CommandButton CmdCancel 
      Cancel          =   -1  'True
      Caption         =   "Cancelar"
      Height          =   375
      Left            =   6720
      TabIndex        =   4
      ToolTipText     =   "Cancela los cambios y oculta esta ventana"
      Top             =   4080
      Width           =   1095
   End
   Begin VB.CommandButton CmdAcept 
      Caption         =   "Aceptar"
      Default         =   -1  'True
      Height          =   375
      Left            =   5520
      TabIndex        =   3
      ToolTipText     =   "Guarda todos los cambios y oculta esta ventana"
      Top             =   4080
      Width           =   1095
   End
   Begin VB.CheckBox Check1 
      Caption         =   "Iniciar aplicacin con Windows"
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   4080
      Width           =   2895
   End
   Begin VB.Frame Frame1 
      Caption         =   "RSS"
      Height          =   3015
      Left            =   120
      TabIndex        =   0
      Top             =   840
      Width           =   9015
      Begin VB.PictureBox Picture1 
         BorderStyle     =   0  'None
         Height          =   1455
         Left            =   7680
         ScaleHeight     =   1455
         ScaleWidth      =   1215
         TabIndex        =   7
         Top             =   360
         Width           =   1215
         Begin VB.CommandButton CmdNew 
            Caption         =   "Nuevo"
            Height          =   375
            Left            =   0
            TabIndex        =   10
            Top             =   0
            Width           =   1095
         End
         Begin VB.CommandButton CmdModify 
            Caption         =   "Modificar"
            Enabled         =   0   'False
            Height          =   375
            Left            =   0
            TabIndex        =   9
            Top             =   480
            Width           =   1095
         End
         Begin VB.CommandButton CmdDelete 
            Caption         =   "Eliminar"
            Enabled         =   0   'False
            Height          =   375
            Left            =   0
            TabIndex        =   8
            Top             =   960
            Width           =   1095
         End
      End
      Begin RssReader.ucLitleListView ucLitleListView1 
         Height          =   2415
         Left            =   240
         TabIndex        =   1
         Top             =   360
         Width           =   7335
         _ExtentX        =   12938
         _ExtentY        =   4260
      End
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H00FFFFFF&
      Caption         =   "Rss Reader"
      BeginProperty Font 
         Name            =   "Algerian"
         Size            =   24
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00F1D8D1&
      Height          =   525
      Left            =   840
      TabIndex        =   6
      Top             =   120
      Width           =   2805
   End
   Begin VB.Image Image2 
      Height          =   555
      Left            =   120
      Picture         =   "FrmMain.frx":058A
      Top             =   80
      Width           =   600
   End
   Begin VB.Image Image1 
      Height          =   705
      Left            =   6240
      Picture         =   "FrmMain.frx":1724
      Top             =   0
      Width           =   3030
   End
   Begin VB.Shape Shape1 
      BackColor       =   &H00FFFFFF&
      BackStyle       =   1  'Opaque
      BorderColor     =   &H00FFD4CC&
      Height          =   1000
      Left            =   -120
      Top             =   -240
      Width           =   9495
   End
End
Attribute VB_Name = "FrmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'--------------------------------------
'Autor: Leandro Ascierto
'Web: www.leandroascierto.com.ar
'Date: 02/07/2011
'Projet Name: RssReader
'---------------------------------------
Private Declare Function LoadLibrary Lib "KERNEL32" Alias "LoadLibraryA" (ByVal lpLibFileName As String) As Long
Private Declare Function FreeLibrary Lib "KERNEL32" (ByVal hLibModule As Long) As Long
Private Declare Sub InitCommonControls Lib "COMCTL32" ()
Private Declare Function SendMessage Lib "user32.dll" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByRef lParam As Any) As Long
Private Const WM_SETICON As Long = &H80

Private WithEvents cSysTray     As ClsSysTray
Attribute cSysTray.VB_VarHelpID = -1
Private cMainMenu               As ClsMainMenu
Private hModShell32             As Long

Private Sub Form_Initialize()
    hModShell32 = LoadLibrary("shell32.dll")
    Call InitCommonControls
End Sub

Private Sub Form_Terminate()
    Call FreeLibrary(hModShell32)
End Sub

Private Sub Form_Load()
    On Error Resume Next
    Dim hIcon As Long
    
    Set cSysTray = New ClsSysTray
    Set cMainMenu = New ClsMainMenu
    
    cMainMenu.Init Me.hwnd
    
    Me.Move (Screen.Width / 2) - (Me.Width / 2), (Screen.Height / 2) - (Me.Height / 2)
    
    If App.LogMode Then
        hIcon = LoadImage(App.hInstance, "ICON_0", IMAGE_ICON, 32, 32, LR_SHARED)
        SendMessage Me.hwnd, WM_SETICON, 1&, ByVal hIcon
        
        hIcon = LoadImage(App.hInstance, "ICON_0", IMAGE_ICON, 16, 16, LR_SHARED)
        SendMessage Me.hwnd, WM_SETICON, 0&, ByVal hIcon
    Else
        hIcon = Me.Icon
    End If
    
    With ucLitleListView1
        .ColumnAdd 0, "URL Feed", 335
        .ColumnAdd 1, "Tiempo de actualizacin", 150
        .FullRowSelect True
    End With
    
    Call ReadData(App.Path & "\Config.txt")
    
    With cSysTray
        .ToolTip = "Rss Reader"
        .Icon = hIcon
        .SysTrayShow True
    End With
    
    If ucLitleListView1.GetItemCount > 0 Then
        CmdDelete.Enabled = True
        CmdModify.Enabled = True
        ucLitleListView1.SetSelectedItem 0
    End If
    
    Call LoadFeed
    
    If IsAutoRun Then
        Check1.Value = 1
    Else
        With cSysTray
            .BalloonTitle = "Rss Reader"
            .BalloonText = cMainMenu.GetRssReadCount & " Feeds cargados"
            .BalloonIcon = TTIconUser
            .BalloonShow True
        End With
    End If
    
End Sub

Private Sub LoadFeed()
    Dim i As Long
    cMainMenu.Clear
    For i = 0 To ucLitleListView1.GetItemCount - 1
        cMainMenu.AddFeed ucLitleListView1.GetItemText(i, 0), ucLitleListView1.ItemData(i)
    Next
    cMainMenu.ActualizeAll
End Sub

Private Sub WriteData(ByVal sPath As String)
On Error GoTo errSub
    Dim n_File As Integer
    Dim i As Long
    
    If Len(Dir(sPath)) Then Kill sPath
    
    n_File = FreeFile
    
    Open sPath For Output As #n_File
        For i = 0 To ucLitleListView1.GetItemCount - 1
            Print #n_File, ucLitleListView1.GetItemText(i, 0) & vbTab & ucLitleListView1.GetItemText(i, 1) & vbTab & ucLitleListView1.ItemData(i)
        Next
    Close #n_File
    Exit Sub
errSub:
    Close #n_File
    MsgBox "Nmero de error: " & Err.Number & vbNewLine & "Descripcin del error: " & Err.Description, vbCritical
End Sub


Private Sub ReadData(ByVal sPath As String)
On Error GoTo errSub

    Dim n_File As Integer
    Dim Linea As String
    Dim vColum() As String
    
    If Len(Dir(sPath)) Then
    
        n_File = FreeFile
        
        Open sPath For Input As n_File
        
        Do While Not EOF(n_File)
            Line Input #n_File, Linea
            vColum = Split(Linea, vbTab)
            ucLitleListView1.ItemAdd ucLitleListView1.GetItemCount, vColum(0), vColum(2)
            ucLitleListView1.SetItemText ucLitleListView1.GetItemCount - 1, 1, vColum(1)
        Loop
        
        Close #n_File
        
        Me.Visible = False
    End If
    Exit Sub
errSub:
    Close #n_File
    MsgBox "Nmero de error: " & Err.Number & vbNewLine & "Descripcin del error: " & Err.Description, vbCritical
End Sub


Private Sub CmdAcept_Click()

    cSysTray.ShowMinimzeToSysTray Me.hwnd
    Me.Visible = False
    
    If Check1.Value = 1 Then
        SetAutoRun True
    Else
        SetAutoRun False
    End If
    
    Call WriteData(App.Path & "\Config.txt")
    
    cSysTray.SysTrayShow False
    Call LoadFeed
    cSysTray.SysTrayShow
    
End Sub

Private Sub CmdDelete_Click()
    ucLitleListView1.ItemRemove ucLitleListView1.GetSelectedItem
    
    If ucLitleListView1.GetItemCount = 0 Then
        CmdDelete.Enabled = False
        CmdModify.Enabled = False
    Else
        ucLitleListView1.SetSelectedItem 0
    End If
End Sub

Private Sub CmdExit_Click()
    Unload Me
End Sub

Private Sub CmdModify_Click()
    Dim i As Long
    Dim lIndex As Long
    lIndex = ucLitleListView1.GetSelectedItem
    With FrmNewEdit
        .Tag = "Modify"
        .Text1 = ucLitleListView1.GetItemText(lIndex, 0)
        For i = 0 To .Combo1.ListCount
            If .Combo1.ItemData(i) = ucLitleListView1.ItemData(lIndex) Then
                .Combo1.ListIndex = i
                Exit For
            End If
        Next
    End With
    FrmNewEdit.Show vbModal, Me
End Sub

Private Sub CmdNew_Click()
    FrmNewEdit.Show vbModal, Me
End Sub

Private Sub CmdCancel_Click()
    cSysTray.ShowMinimzeToSysTray Me.hwnd
    Me.Visible = False
End Sub

Private Sub cSysTray_MouseUp(Button As Integer)
    Dim lRet As Long
    cSysTray.BeforePopup
    lRet = cMainMenu.PopUpMenu(Me.hwnd)
    Select Case lRet
        Case 101
            cSysTray.ShowRestoreFromSysTray Me.hwnd
            Me.Show
        Case 102
            Unload Me
            If App.LogMode Then
                End
            End If
    End Select
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    Debug.Print UnloadMode
    If UnloadMode = 0 Then
        cSysTray.ShowMinimzeToSysTray Me.hwnd
        Me.Visible = False
        Cancel = 1
    End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
     cSysTray.SysTrayShow False
     Unload FrmMedia
    Set cSysTray = Nothing
    Set cMainMenu = Nothing     ' Descargamos la clase.
End Sub

